<?php

namespace App\Http\Controllers\google_map;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth;
use DateTime;

class GoogleMapController extends Controller
{
    public function mapView(){

       $condition = '';
       if(Auth::user()->is_admin == '1'){
        $condition .= '';
       }else{
        $empNumber = Auth::user()->employee_number;
        $productCodes = DB::table('location_report_map')
                        ->where('employee_number', $empNumber)
                        ->pluck('product_code') // Get an array of product_code values
                        ->implode(',');

        $condition .= "AND PRODUCT_CODE IN ($productCodes)";

       }

        $salesrep = DB::connection('oracle')->select("SELECT DISTINCT emp.EMPLOYEE_NUMBER, people.FULL_NAME
                                            FROM (
                                                SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER 
                                                FROM XX_CUSTTERRSRZMDM 
                                                WHERE END_DATE_ACTIVE IS NULL
                                                $condition
                                                AND SALESREP_NUMBER IS NOT NULL

                                                UNION

                                                SELECT ZM_NUMBER AS EMPLOYEE_NUMBER
                                                FROM XX_CUSTTERRSRZMDM 
                                                WHERE END_DATE_ACTIVE IS NULL
                                                 $condition
                                                AND ZM_NUMBER IS NOT NULL

                                                UNION

                                                SELECT DM_NUMBER AS EMPLOYEE_NUMBER
                                                FROM XX_CUSTTERRSRZMDM 
                                                WHERE END_DATE_ACTIVE IS NULL
                                                 $condition
                                                AND DM_NUMBER IS NOT NULL
                                            ) emp
                                            JOIN APPS.PER_PEOPLE_F@sales people 
                                            ON emp.EMPLOYEE_NUMBER = people.EMPLOYEE_NUMBER
                                            WHERE TRUNC(SYSDATE) BETWEEN TRUNC(people.EFFECTIVE_START_DATE) 
                                                                    AND TRUNC(people.EFFECTIVE_END_DATE)
                                            ");

        $alllocations = DB::connection('oracle')->select("SELECT LATITUDE,LONGITUDE,IMG_URL,ATTENDANCE_DATE,FULL_NAME,PHONE,EMPLOYEE_NUMBER,OFFICE_ID_CARD,DESIGNATION,ATTENDANCE_TYPE FROM XX_EMP_ATTENDANCE ATTN, APPS.XXDESIGNATIONWISESRZMDM@SALES MOBEMP
            WHERE ATTN.EMPLOYEE_NUMBER = MOBEMP.EMPLOYEE_CODE
            AND TRUNC(ATTENDANCE_DATE) = TRUNC(SYSDATE) AND LATITUDE > 0 AND LONGITUDE > 0");
            

        $employeeNumbers = collect($salesrep)->pluck('employee_number')->toArray();

        $filteredLocations = array_filter($alllocations, function ($location) use ($employeeNumbers) {
            return in_array($location->employee_number, $employeeNumbers);
        });
        $locations = array_values($filteredLocations);
        
        return view('googleMapView', compact('locations','salesrep'));
    }
    public function searchEmpLocation(Request $request){

        $header = array(
            'pageTitle' => 'Location',
            'tableTitle' => ''
        );

        $fromDate = date('Y-m-d',strtotime($request->fromDate));
        $toDate = date('Y-m-d',strtotime($request->toDate));
        $salesRep = $request->empId;

        $condition = "";

        if(!empty($toDate)){
            $condition .=" AND ATTN.ATTENDANCE_DATE BETWEEN '$fromDate' AND '$toDate'";
        }

        if(!empty($salesRep)){
            $condition .= " AND ATTN.EMPLOYEE_NUMBER = '$salesRep' ";
        }
       

        $locations = DB::connection('oracle')->select("SELECT LATITUDE,LONGITUDE,IMG_URL,ATTENDANCE_DATE,FULL_NAME,PHONE,EMPLOYEE_NUMBER,OFFICE_ID_CARD,DESIGNATION,ATTENDANCE_TYPE FROM XX_EMP_ATTENDANCE ATTN, APPS.XXDESIGNATIONWISESRZMDM@SALES MOBEMP
                                WHERE ATTN.EMPLOYEE_NUMBER = MOBEMP.EMPLOYEE_CODE
                   $condition 
                   AND LATITUDE > 0 AND LONGITUDE > 0           
        ");

       // return response()->json($locations);
        return $locations;

        //return view('searchLocation',compact('locations','header'));
    }

    public function attendanceReport(){
        $header = array(
            'pageTitle' => 'Attendance Report',
            'tableTitle' => ''
        );

        $condition = '';
        $productCodes = "501,502,701";

        if(Auth::user()->is_admin == '1'){
            $condition .= '';
        }else{
            $empNumber = Auth::user()->employee_number;
            $orgId = Auth::user()->org_id;
           
            $productCodes = DB::table('location_report_map')
                             ->where('employee_number', $empNumber)
                             ->where('org_id', $orgId)
                             ->pluck('product_code') // Get an array of product_code values
                             ->implode(',');
            $condition .= "AND PRODUCT_CODE IN ($productCodes)";
        }
        

        if($productCodes){
            $division = DB::connection('oracle')->select("SELECT DISTINCT t2.DIV_ID, t2.DIVISION
                    FROM XX_CUSTTERRSRZMDM t1
                    JOIN XX_RA_TERRITORIES t2 ON t1.TERRITORY_ID = t2.TERRITORY_ID
                    WHERE t1.END_DATE_ACTIVE IS NULL
                    AND t1.PRODUCT_CODE IN ($productCodes)
                    ");
            $zone  = DB::connection('oracle')->select("SELECT DISTINCT t2.ZONE_ID, t2.ZONE
            FROM XX_CUSTTERRSRZMDM t1
            JOIN XX_RA_TERRITORIES t2 ON t1.TERRITORY_ID = t2.TERRITORY_ID
            WHERE t1.END_DATE_ACTIVE IS NULL
            AND t1.PRODUCT_CODE IN ($productCodes)
            ");
        }
        
       
        if(Auth::user()){
            $salesrep = DB::connection('oracle')->select("SELECT DISTINCT 
                                    emp.EMPLOYEE_NUMBER, 
                                    emp.PRODUCT_NAME, 
                                    people.FULL_NAME, 
                                    people.ATTRIBUTE3, 
                                    people.ATTRIBUTE5
                                FROM (
                                    SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME 
                                    FROM XX_CUSTTERRSRZMDM 
                                    WHERE END_DATE_ACTIVE IS NULL
                                    $condition
                                    AND SALESREP_NUMBER IS NOT NULL

                                    UNION

                                    SELECT ZM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME
                                    FROM XX_CUSTTERRSRZMDM 
                                    WHERE END_DATE_ACTIVE IS NULL
                                    $condition
                                    AND ZM_NUMBER IS NOT NULL

                                    UNION

                                    SELECT DM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME
                                    FROM XX_CUSTTERRSRZMDM 
                                    WHERE END_DATE_ACTIVE IS NULL
                                    $condition
                                    AND DM_NUMBER IS NOT NULL
                                ) emp
                                JOIN APPS.PER_PEOPLE_F@sales people 
                                    ON emp.EMPLOYEE_NUMBER = people.EMPLOYEE_NUMBER
                                LEFT JOIN EMPLOYEE_NO_ATTENDANCE ena 
                                    ON emp.EMPLOYEE_NUMBER = ena.EMPLOYEE_NUMBER
                                WHERE ena.EMPLOYEE_NUMBER IS NULL  -- Exclude employees present in EMPLOYEE_NO_ATTENDANCE
                                AND TRUNC(SYSDATE) BETWEEN TRUNC(people.EFFECTIVE_START_DATE) 
                                                        AND TRUNC(people.EFFECTIVE_END_DATE)
                            ");

                            $salesrep = DB::connection('oracle')->select("SELECT 
                                        emp.EMPLOYEE_NUMBER, 
                                        MAX(emp.PRODUCT_NAME) AS PRODUCT_NAME, 
                                        MAX(people.FULL_NAME) AS FULL_NAME, 
                                        MAX(people.ATTRIBUTE3) AS ATTRIBUTE3, 
                                        MAX(people.ATTRIBUTE5) AS ATTRIBUTE5, 
                                        MAX(t2.DIVISION) AS DIVISION,  -- Fetching Division Name
                                        MAX(t2.ZONE) AS ZONE           -- Fetching Zone Name
                                    FROM (
                                        SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME, TERRITORY_ID
                                        FROM XX_CUSTTERRSRZMDM 
                                        WHERE END_DATE_ACTIVE IS NULL
                                        $condition
                                        AND SALESREP_NUMBER IS NOT NULL

                                        UNION

                                        SELECT ZM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME, TERRITORY_ID
                                        FROM XX_CUSTTERRSRZMDM 
                                        WHERE END_DATE_ACTIVE IS NULL
                                        $condition
                                        AND ZM_NUMBER IS NOT NULL

                                        UNION

                                        SELECT DM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME, TERRITORY_ID
                                        FROM XX_CUSTTERRSRZMDM 
                                        WHERE END_DATE_ACTIVE IS NULL
                                        $condition
                                        AND DM_NUMBER IS NOT NULL
                                    ) emp
                                    JOIN XX_RA_TERRITORIES t2 
                                        ON emp.TERRITORY_ID = t2.TERRITORY_ID
                                    JOIN APPS.PER_PEOPLE_F@sales people 
                                        ON emp.EMPLOYEE_NUMBER = people.EMPLOYEE_NUMBER
                                    LEFT JOIN EMPLOYEE_NO_ATTENDANCE ena 
                                        ON emp.EMPLOYEE_NUMBER = ena.EMPLOYEE_NUMBER
                                    WHERE ena.EMPLOYEE_NUMBER IS NULL  -- Exclude employees present in EMPLOYEE_NO_ATTENDANCE
                                    AND TRUNC(SYSDATE) BETWEEN TRUNC(people.EFFECTIVE_START_DATE) 
                                                            AND TRUNC(people.EFFECTIVE_END_DATE)
                                    GROUP BY emp.EMPLOYEE_NUMBER");
                            
                            $alllocations = DB::connection('oracle')->select('SELECT LATITUDE, LONGITUDE, IMG_URL, ATTENDANCE_DATE, FULL_NAME, 
                                    MOBEMP.ATTRIBUTE5 "PHONE", ATTN.EMPLOYEE_NUMBER, MOBEMP.ATTRIBUTE3 "OFFICE_ID_CARD",ATTENDANCE_TYPE 
                                FROM XX_EMP_ATTENDANCE ATTN, APPS.PER_PEOPLE_F@SALES MOBEMP
                                WHERE ATTN.EMPLOYEE_NUMBER = MOBEMP.EMPLOYEE_NUMBER
                                AND TRUNC(ATTENDANCE_DATE) = TRUNC(SYSDATE) 
                                AND TRUNC (SYSDATE) BETWEEN TRUNC (MOBEMP.EFFECTIVE_START_DATE)
                                  AND TRUNC (MOBEMP.EFFECTIVE_END_DATE)');

                           
                            // $salesrepMap = collect($salesrep)->mapWithKeys(function ($item) {
                            //     return [$item->employee_number => $item->product_name];
                            // })->toArray();
                            $salesrepMap = collect($salesrep)->mapWithKeys(function ($item) {
                                return [
                                    $item->employee_number => [
                                        'product_name' => $item->product_name,
                                        'division' => $item->division,
                                        'zone' => $item->zone
                                    ]
                                ];
                            })->toArray();

                            // Filter locations and add product_name
                            $filteredLocations = array_map(function ($location) use ($salesrepMap) {
                                if (isset($salesrepMap[$location->employee_number])) {
                                    $location->product_name = $salesrepMap[$location->employee_number]['product_name']; // Assign product_name
                                    $location->division = $salesrepMap[$location->employee_number]['division']; // Assign division
                                    $location->zone = $salesrepMap[$location->employee_number]['zone']; // Assign zone
                                } else {
                                    $location->product_name = null;
                                    $location->division = null;
                                    $location->zone = null;
                                }
                                return $location;
                            }, array_filter($alllocations, function ($location) use ($salesrepMap) {
                                return isset($salesrepMap[$location->employee_number]);
                            }));

                            $results = array_values($filteredLocations);
                            $divisions = $division ? $division : [];
                            $zones = $zone ? $zone : [];

        return view('attendance_reprot.index',compact('header','results','salesrep','divisions','zones'));
        }else{
            $header = array(
                'pageTitle' => 'Attendance Report',
                'tableTitle' => ''
            );
            return view('attendance_reprot.permission_denei',compact('header')); 
        }
         
    }

    public function searchTodayAttendance(Request $request){

        $attendnaceType = $request->attendanceType;
        $employeeNo = $request->employeeNumber;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $divId = $request->divId;
        $zoneId = $request->zoneId;

        

        $productCondition = '';

        if(Auth::user()->is_admin=='1'){
            $productCondition .= ''; 
        }else{

            $empNumber = Auth::user()->employee_number;
            $orgId = Auth::user()->org_id;
           
            $productCodes = DB::table('location_report_map')
            ->where('employee_number', $empNumber)
            ->where('org_id', $orgId)
            ->pluck('product_code') // Get an array of product_code values
            ->implode(',');
            $productCondition .= " AND PRODUCT_CODE IN ($productCodes)";
        }

        $condition = "";

        if(!empty($employeeNo)){
            $condition .= "AND ATTN.EMPLOYEE_NUMBER = $employeeNo";
        }
        if(!empty($fromDate) && !empty($toDate)){
            $condition .= "AND TRUNC(ATTENDANCE_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')";
        }else{
            $condition .= " AND TRUNC(ATTENDANCE_DATE) = TRUNC(SYSDATE) ";
        }

        $absenCondition = "";
        if($attendnaceType == '2' && !empty($employeeNo)){
            $absenCondition .= "and emp.EMPLOYEE_NUMBER =  $employeeNo" ;
        }

        $terrCondition = '';

        if(!empty($divId)){
            $terrCondition .= " AND t2.DIV_ID = '$divId'";
        }
        if(!empty($zoneId)){
            $terrCondition .= " AND t2.ZONE_ID = '$zoneId'";
        }


        if(Auth::user()){
            // $salesrep = DB::connection('oracle')->select("
            //                     SELECT DISTINCT 
            //                         emp.EMPLOYEE_NUMBER, 
            //                         emp.PRODUCT_NAME, 
            //                         people.FULL_NAME, 
            //                         people.ATTRIBUTE3, 
            //                         people.ATTRIBUTE5
            //                     FROM (
            //                         SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME 
            //                         FROM XX_CUSTTERRSRZMDM 
            //                         WHERE END_DATE_ACTIVE IS NULL
            //                         $productCondition
            //                         AND SALESREP_NUMBER IS NOT NULL

            //                         UNION

            //                         SELECT ZM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME
            //                         FROM XX_CUSTTERRSRZMDM 
            //                         WHERE END_DATE_ACTIVE IS NULL
            //                          $productCondition
            //                         AND ZM_NUMBER IS NOT NULL

            //                         UNION

            //                         SELECT DM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME
            //                         FROM XX_CUSTTERRSRZMDM 
            //                         WHERE END_DATE_ACTIVE IS NULL
            //                          $productCondition
            //                         AND DM_NUMBER IS NOT NULL
            //                     ) emp
            //                     JOIN APPS.PER_PEOPLE_F@sales people 
            //                         ON emp.EMPLOYEE_NUMBER = people.EMPLOYEE_NUMBER
            //                     LEFT JOIN EMPLOYEE_NO_ATTENDANCE ena 
            //                         ON emp.EMPLOYEE_NUMBER = ena.EMPLOYEE_NUMBER
            //                     WHERE ena.EMPLOYEE_NUMBER IS NULL  -- Exclude employees present in EMPLOYEE_NO_ATTENDANCE
            //                     AND TRUNC(SYSDATE) BETWEEN TRUNC(people.EFFECTIVE_START_DATE) 
            //                                             AND TRUNC(people.EFFECTIVE_END_DATE)
            //                                             $absenCondition
            //                 ");

                            $salesrep = DB::connection('oracle')->select("SELECT 
                                    emp.EMPLOYEE_NUMBER, 
                                    MAX(emp.PRODUCT_NAME) AS PRODUCT_NAME, 
                                    MAX(people.FULL_NAME) AS FULL_NAME, 
                                    MAX(people.ATTRIBUTE3) AS CARD_NO, 
                                    MAX(people.ATTRIBUTE5) AS PHONE, 
                                    MAX(t2.DIVISION) AS DIVISION,  -- Fetching Division Name
                                    MAX(t2.ZONE) AS ZONE           -- Fetching Zone Name
                                FROM (
                                    SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME, TERRITORY_ID
                                    FROM XX_CUSTTERRSRZMDM 
                                    WHERE END_DATE_ACTIVE IS NULL
                                    $productCondition
                                    AND SALESREP_NUMBER IS NOT NULL

                                    UNION

                                    SELECT ZM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME, TERRITORY_ID
                                    FROM XX_CUSTTERRSRZMDM 
                                    WHERE END_DATE_ACTIVE IS NULL
                                    $productCondition
                                    AND ZM_NUMBER IS NOT NULL

                                    UNION

                                    SELECT DM_NUMBER AS EMPLOYEE_NUMBER, PRODUCT_NAME, TERRITORY_ID
                                    FROM XX_CUSTTERRSRZMDM 
                                    WHERE END_DATE_ACTIVE IS NULL
                                    $productCondition
                                    AND DM_NUMBER IS NOT NULL
                                ) emp
                                JOIN XX_RA_TERRITORIES t2 
                                    ON emp.TERRITORY_ID = t2.TERRITORY_ID
                                    $terrCondition
                                JOIN APPS.PER_PEOPLE_F@sales people 
                                    ON emp.EMPLOYEE_NUMBER = people.EMPLOYEE_NUMBER
                                LEFT JOIN EMPLOYEE_NO_ATTENDANCE ena 
                                    ON emp.EMPLOYEE_NUMBER = ena.EMPLOYEE_NUMBER
                                WHERE ena.EMPLOYEE_NUMBER IS NULL  -- Exclude employees present in EMPLOYEE_NO_ATTENDANCE
                                AND TRUNC(SYSDATE) BETWEEN TRUNC(people.EFFECTIVE_START_DATE) 
                                                        AND TRUNC(people.EFFECTIVE_END_DATE)
                                GROUP BY emp.EMPLOYEE_NUMBER

                                                        $absenCondition
                            ");

                            $alllocations = DB::connection('oracle')->select("
                                SELECT LATITUDE, LONGITUDE, IMG_URL, ATTENDANCE_DATE, FULL_NAME, 
                                   MOBEMP.ATTRIBUTE5 AS PHONE , ATTN.EMPLOYEE_NUMBER, MOBEMP.ATTRIBUTE3 AS OFFICE_ID_CARD, ATTENDANCE_TYPE 
                                FROM XX_EMP_ATTENDANCE ATTN, APPS.PER_PEOPLE_F@SALES MOBEMP
                                WHERE ATTN.EMPLOYEE_NUMBER = MOBEMP.EMPLOYEE_NUMBER
                               $condition
                                 AND TRUNC (SYSDATE) BETWEEN TRUNC (MOBEMP.EFFECTIVE_START_DATE)
                                  AND TRUNC (MOBEMP.EFFECTIVE_END_DATE)
                            ");

            $employeeNumbers = collect($salesrep)->pluck('employee_number')->toArray();

            if($attendnaceType == '2'){
            // today absent employee start here
            $attendanceEmployeeNumbers = collect($alllocations)->pluck('employee_number')->toArray();
            $filteredNotAttendance = array_diff($employeeNumbers, $attendanceEmployeeNumbers);

            $absentEmployeeList = array_map(function ($rep) {
                $rep->img_url = ''; 
                $rep->attendance_date = ''; 
                $rep->attendance_type = '';
                return $rep;
            }, array_filter($salesrep, function ($rep) use ($filteredNotAttendance) {
                return in_array($rep->employee_number, $filteredNotAttendance);
            }));

            $results = array_values($absentEmployeeList);
            return view('attendance_reprot.search_today_attendance',compact('results'));
            }else if($attendnaceType == '1'){

                // $salesrepMap = collect($salesrep)->mapWithKeys(function ($item) {
                //     return [$item->employee_number => $item->product_name];
                // })->toArray();
                $salesrepMap = collect($salesrep)->mapWithKeys(function ($item) {
                    return [
                        $item->employee_number => [
                            'product_name' => $item->product_name,
                            'division' => $item->division,
                            'zone' => $item->zone
                        ]
                    ];
                })->toArray();
               
                $filteredLocations = array_map(function ($location) use ($salesrepMap) {
                    if (isset($salesrepMap[$location->employee_number])) {
                        $location->product_name = $salesrepMap[$location->employee_number]['product_name']; // Assign product_name
                        $location->division = $salesrepMap[$location->employee_number]['division']; // Assign division
                        $location->zone = $salesrepMap[$location->employee_number]['zone']; // Assign zone
                    } else {
                        $location->product_name = null;
                        $location->division = null;
                        $location->zone = null;
                    }
                    return $location;
                }, array_filter($alllocations, function ($location) use ($salesrepMap) {
                    return isset($salesrepMap[$location->employee_number]);
                }));

                $results = array_values($filteredLocations);

                // today present end here

                return view('attendance_reprot.search_today_attendance',compact('results'));
            }else{

                $salesrepMap = collect($salesrep)->mapWithKeys(function ($item) {
                    return [
                        $item->employee_number => [
                            'product_name' => $item->product_name,
                            'division' => $item->division,
                            'zone' => $item->zone
                        ]
                    ];
                })->toArray();
               
                $filteredLocations = array_map(function ($location) use ($salesrepMap) {
                    if (isset($salesrepMap[$location->employee_number])) {
                        $location->product_name = $salesrepMap[$location->employee_number]['product_name']; // Assign product_name
                        $location->division = $salesrepMap[$location->employee_number]['division']; // Assign division
                        $location->zone = $salesrepMap[$location->employee_number]['zone']; // Assign zone
                    } else {
                        $location->product_name = null;
                        $location->division = null;
                        $location->zone = null;
                    }
                    return $location;
                }, array_filter($alllocations, function ($location) use ($salesrepMap) {
                    return isset($salesrepMap[$location->employee_number]);
                }));

                $totalPresent = array_values($filteredLocations);

            $attendanceEmployeeNumbers = collect($alllocations)->pluck('employee_number')->toArray();
            $filteredNotAttendance = array_diff($employeeNumbers, $attendanceEmployeeNumbers);

            $absentEmployeeList = array_map(function ($rep) {
                $rep->img_url = ''; 
                $rep->attendance_date = ''; 
                $rep->attendance_type = '';
                return $rep;
            }, array_filter($salesrep, function ($rep) use ($filteredNotAttendance) {
                return in_array($rep->employee_number, $filteredNotAttendance);
            }));

            $totalAbsent = array_values($absentEmployeeList);

            $results = array_merge($totalPresent,$totalAbsent);
            return view('attendance_reprot.search_today_attendance',compact('results'));

            }
}else{
    $header = array(
        'pageTitle' => 'Attendance Report',
        'tableTitle' => ''
    );
    return view('attendance_reprot.permission_denei',compact('header')); 
}
    }

    public function attendanceSummary(){
        $header = array(
            'pageTitle' => 'Attendance Summary',
            'tableTitle' => ''
        );

        $fromDate = date('01-M-Y');
        $toDate = date('t-M-Y');
        
        $results = DB::connection('oracle')->select("
        SELECT EMP.EMPLOYEE_NUMBER, 
               PEOPLE.FULL_NAME, 
               PEOPLE.ATTRIBUTE3, 
               PEOPLE.ATTRIBUTE5,
               COALESCE(ATTENDANCE.TOTAL_ATTENDANCE, 0) AS TOTAL_ATTENDANCE
        FROM (
            SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER 
            FROM XX_CUSTTERRSRZMDM 
            WHERE END_DATE_ACTIVE IS NULL AND SALESREP_NUMBER IS NOT NULL
    
            UNION
    
            SELECT ZM_NUMBER AS EMPLOYEE_NUMBER
            FROM XX_CUSTTERRSRZMDM 
            WHERE END_DATE_ACTIVE IS NULL AND ZM_NUMBER IS NOT NULL
    
            UNION
    
            SELECT DM_NUMBER AS EMPLOYEE_NUMBER
            FROM XX_CUSTTERRSRZMDM 
            WHERE END_DATE_ACTIVE IS NULL AND DM_NUMBER IS NOT NULL
        ) EMP
        JOIN APPS.PER_PEOPLE_F@SALES PEOPLE 
            ON EMP.EMPLOYEE_NUMBER = PEOPLE.EMPLOYEE_NUMBER
        LEFT JOIN (
            SELECT EMPLOYEE_NUMBER, COUNT(DISTINCT TRUNC(ATTENDANCE_DATE)) AS TOTAL_ATTENDANCE
            FROM XX_EMP_ATTENDANCE
            WHERE TRUNC(ATTENDANCE_DATE) BETWEEN TO_DATE('$fromDate', 'DD-MM-YYYY') 
                                             AND TO_DATE('$toDate', 'DD-MM-YYYY')
            GROUP BY EMPLOYEE_NUMBER
        ) ATTENDANCE
            ON EMP.EMPLOYEE_NUMBER = ATTENDANCE.EMPLOYEE_NUMBER
        WHERE TRUNC(SYSDATE) BETWEEN TRUNC(PEOPLE.EFFECTIVE_START_DATE) 
                                AND TRUNC(PEOPLE.EFFECTIVE_END_DATE)
        GROUP BY EMP.EMPLOYEE_NUMBER, 
                 PEOPLE.FULL_NAME, 
                 PEOPLE.ATTRIBUTE3, 
                 PEOPLE.ATTRIBUTE5, 
                 ATTENDANCE.TOTAL_ATTENDANCE
    ");        
        
        return view('attendance_summary.index',compact('header','results','fromDate','toDate'));
    }

    public function viewAttendance(Request $request,$empNumber,$fromDate,$toDate){
        $header = array(
            'pageTitle' => 'Attendance Summary',
            'tableTitle' => ''
        );
        $results = DB::connection('oracle')->select("SELECT ATTENDANCE_DATE,ATTENDANCE_TYPE
        FROM XX_EMP_ATTENDANCE
        WHERE TRUNC(ATTENDANCE_DATE) BETWEEN TO_DATE('$fromDate', 'DD-MM-YYYY') 
                                         AND TO_DATE('$toDate', 'DD-MM-YYYY')
                                         AND EMPLOYEE_NUMBER = $empNumber
                                         ORDER BY ATTENDANCE_DATE ASC"); 

        return view('attendance_summary.view_attendance',compact('header','results'));
    }

    public function searchAttendanceSummary(Request $request){
        $header = array(
            'pageTitle' => 'Attendance Summary',
            'tableTitle' => ''
        );
        $monthYear =$request->startDate;
        $fromDate = (new DateTime($monthYear))->modify('first day of this month')->format('d-M-Y');
        $toDate = (new DateTime($monthYear))->modify('last day of this month')->format('d-M-Y');
        
        $results = DB::connection('oracle')->select("
                                    SELECT EMP.EMPLOYEE_NUMBER, 
                                        PEOPLE.FULL_NAME, 
                                        PEOPLE.ATTRIBUTE3, 
                                        PEOPLE.ATTRIBUTE5,
                                        COALESCE(ATTENDANCE.TOTAL_ATTENDANCE, 0) AS TOTAL_ATTENDANCE
                                    FROM (
                                        SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER 
                                        FROM XX_CUSTTERRSRZMDM 
                                        WHERE END_DATE_ACTIVE IS NULL AND SALESREP_NUMBER IS NOT NULL
                                
                                        UNION
                                
                                        SELECT ZM_NUMBER AS EMPLOYEE_NUMBER
                                        FROM XX_CUSTTERRSRZMDM 
                                        WHERE END_DATE_ACTIVE IS NULL AND ZM_NUMBER IS NOT NULL
                                
                                        UNION
                                
                                        SELECT DM_NUMBER AS EMPLOYEE_NUMBER
                                        FROM XX_CUSTTERRSRZMDM 
                                        WHERE END_DATE_ACTIVE IS NULL AND DM_NUMBER IS NOT NULL
                                    ) EMP
                                    JOIN APPS.PER_PEOPLE_F@SALES PEOPLE 
                                        ON EMP.EMPLOYEE_NUMBER = PEOPLE.EMPLOYEE_NUMBER
                                    LEFT JOIN (
                                        SELECT EMPLOYEE_NUMBER, COUNT(DISTINCT TRUNC(ATTENDANCE_DATE)) AS TOTAL_ATTENDANCE
                                        FROM XX_EMP_ATTENDANCE
                                        WHERE TRUNC(ATTENDANCE_DATE) BETWEEN TO_DATE('$fromDate', 'DD-MM-YYYY') 
                                                                        AND TO_DATE('$toDate', 'DD-MM-YYYY')
                                        GROUP BY EMPLOYEE_NUMBER
                                    ) ATTENDANCE
                                        ON EMP.EMPLOYEE_NUMBER = ATTENDANCE.EMPLOYEE_NUMBER
                                    WHERE TRUNC(SYSDATE) BETWEEN TRUNC(PEOPLE.EFFECTIVE_START_DATE) 
                                                            AND TRUNC(PEOPLE.EFFECTIVE_END_DATE)
                                    GROUP BY EMP.EMPLOYEE_NUMBER, 
                                            PEOPLE.FULL_NAME, 
                                            PEOPLE.ATTRIBUTE3, 
                                            PEOPLE.ATTRIBUTE5, 
                                            ATTENDANCE.TOTAL_ATTENDANCE
                                "); 

     return view('attendance_summary.search_attendance_summary',compact('header','results','fromDate','toDate'));

    }

    public function searchTotalAttendance(Request $request){
        $header = array(
            'pageTitle' => 'Attendance Summary',
            'tableTitle' => ''
        );
        $attendnaceType = $request->attendanceType;
        $condition = "";
        if($attendnaceType =='1'){
            $condition.= 'AND COALESCE(ATTENDANCE.TOTAL_ATTENDANCE, 0) <> 0';
        }else{
            $condition.= 'AND COALESCE(ATTENDANCE.TOTAL_ATTENDANCE, 0) = 0';
        }

        $fromDate = date('01-M-Y');
        $toDate = date('t-M-Y');
        
        $results = DB::connection('oracle')->select("SELECT EMP.EMPLOYEE_NUMBER, 
       PEOPLE.FULL_NAME, 
       PEOPLE.ATTRIBUTE3, 
       PEOPLE.ATTRIBUTE5,
       COALESCE(ATTENDANCE.TOTAL_ATTENDANCE, 0) AS TOTAL_ATTENDANCE
FROM (
    SELECT SALESREP_NUMBER AS EMPLOYEE_NUMBER 
    FROM XX_CUSTTERRSRZMDM 
    WHERE END_DATE_ACTIVE IS NULL AND SALESREP_NUMBER IS NOT NULL AND SALESREP_NUMBER NOT IN (0001,0002,1,99999)

    UNION

    SELECT ZM_NUMBER AS EMPLOYEE_NUMBER
    FROM XX_CUSTTERRSRZMDM 
    WHERE END_DATE_ACTIVE IS NULL AND ZM_NUMBER IS NOT NULL AND ZM_NUMBER NOT IN (0001,0002,1,99999)

    UNION

    SELECT DM_NUMBER AS EMPLOYEE_NUMBER
    FROM XX_CUSTTERRSRZMDM 
    WHERE END_DATE_ACTIVE IS NULL AND DM_NUMBER IS NOT NULL AND DM_NUMBER NOT IN (0001,0002,1,99999)
) EMP
JOIN APPS.PER_PEOPLE_F@SALES PEOPLE 
    ON EMP.EMPLOYEE_NUMBER = PEOPLE.EMPLOYEE_NUMBER
LEFT JOIN (
    SELECT EMPLOYEE_NUMBER, COUNT(DISTINCT TRUNC(ATTENDANCE_DATE)) AS TOTAL_ATTENDANCE
    FROM XX_EMP_ATTENDANCE
    WHERE TRUNC(ATTENDANCE_DATE) BETWEEN TO_DATE('$fromDate', 'DD-MM-YYYY') 
                                     AND TO_DATE('$toDate', 'DD-MM-YYYY')
    GROUP BY EMPLOYEE_NUMBER
) ATTENDANCE
    ON EMP.EMPLOYEE_NUMBER = ATTENDANCE.EMPLOYEE_NUMBER
WHERE TRUNC(SYSDATE) BETWEEN TRUNC(PEOPLE.EFFECTIVE_START_DATE) 
                        AND TRUNC(PEOPLE.EFFECTIVE_END_DATE)
                        
$condition
"); 
return view('attendance_summary.search_attendance_summary',compact('header','results','fromDate','toDate'));

    }
}
